#include <cstdio>
#include <bits/stdc++.h>
using namespace std;

const int N = 3e5 + 5;
const int MAX_NUM = 1e6 + 5;

int n, q;
int a[N];

vector<int> pojavljivanja[MAX_NUM];

double res[MAX_NUM];
int resL[MAX_NUM], resD[MAX_NUM];

void init()
{
    for (int i = 0; i < MAX_NUM; i++)
    {
        res[i] = -1;
    }

    for (int i = 0; i < n; i++)
    {
        pojavljivanja[a[i]].push_back(i);
    }
}

// x^a
double stepen(double x, int a)
{
    if (a == 1)
    {
        return x;
    }

    double s = stepen(x, a/2);

    if (a%2 == 0)
    {
        return s * s;
    }
    return s * s * x;
}

void resi(int qi)
{
    if (pojavljivanja[0].size() == n)
    {
        res[qi] = 0;
        resL[qi] = resD[qi] = 0;
        return;
    }

    if (qi == 0 || qi == 1 || pojavljivanja[qi].size() == 0)
    {
        res[qi] = 1;
        if (pojavljivanja[0].size() == 0)
        {
            resL[qi] = resD[qi] = 0;
        }
        else
        {
            for (int i = 0; i < pojavljivanja[0].size(); i++)
            {
                if (pojavljivanja[0][i] != i)
                {
                    resL[qi] = resD[qi] = i;
                    break;
                }
            }
        }
        return;
    }

    for (int i = 0; i < pojavljivanja[qi].size();)
    {
        int jGranica = n;
        auto sledecaNula = upper_bound(pojavljivanja[0].begin(), pojavljivanja[0].end(), pojavljivanja[qi][i]);
        if (sledecaNula < pojavljivanja[0].end())
        {
            jGranica = *sledecaNula;
        }

        int j;
        for (j = i; j < pojavljivanja[qi].size() && pojavljivanja[qi][j] < jGranica; j++)
        {
            int l = pojavljivanja[qi][i], d = pojavljivanja[qi][j];
            double specVred = stepen(qi, j - i + 1) / (d - l + 1);

            if (res[qi] == -1 || specVred > res[qi])
            {
                res[qi] = specVred;
                resL[qi] = l;
                resD[qi] = d;
            }
        }

        i = j;
    }
}

int main()
{
    scanf("%d%d", &n, &q);
    for (int i = 0; i < n; i++)
    {
        scanf("%d", a + i);
    }

    init();
    while (q--)
    {
        int qi;
        scanf("%d", &qi);

        if (res[qi] == -1)
        {
            resi(qi);
        }

        printf("%d %d\n", resL[qi], resD[qi]);
    }

    return 0;
}